/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.KeyStroke;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.CompoundBorder;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicComboBoxUI;
import com.sun.java.swing.plaf.motif.MotifBorderFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;

public class MotifComboBoxUI
extends BasicComboBoxUI
implements Serializable {
    Icon arrowIcon;
    static final int HORIZ_MARGIN = 3;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifComboBoxUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setBorder((Border)new CompoundBorder(MotifBorderFactory.getFocusBorder(), MotifBorderFactory.getRaisedBevelBorder()));
        this.arrowIcon = new MotifComboBoxArrowIcon(UIManager.getColor((Object)"controlHighlight"), UIManager.getColor((Object)"controlShadow"), UIManager.getColor((Object)"control"));
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setBorder(null);
    }

    protected void configureComboBox() {
        LookAndFeel.installColorsAndFont((JComponent)this.comboBox, (String)"ComboBox.control", (String)"ComboBox.controlForeground", (String)"ComboBox.font");
    }

    protected void unconfigureComboBox() {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.comboBox.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.comboBox.repaint();
    }

    public void addArrowButton() {
    }

    public void removeArrowButton() {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle;
        boolean bl = this.comboBox.hasFocus();
        graphics.setColor(this.comboBox.getBackground());
        graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        if (!this.comboBox.isEditable()) {
            rectangle = this.rectangleForCurrentValue();
            this.paintCurrentValue(graphics, rectangle, bl);
        }
        rectangle = this.rectangleForArrowIcon();
        this.arrowIcon.paintIcon((Component)jComponent, graphics, rectangle.x, rectangle.y);
        if (!this.comboBox.isEditable()) {
            Border border = this.comboBox.getBorder();
            Insets insets = border.getBorderInsets((Component)this.comboBox);
            rectangle.x -= 5;
            rectangle.y = insets.top;
            rectangle.width = 1;
            rectangle.height = this.comboBox.getBounds().height - insets.bottom - insets.top;
            graphics.setColor(UIManager.getColor((Object)"controlShadow"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ++rectangle.x;
            graphics.setColor(UIManager.getColor((Object)"controlHighlight"));
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        this.validateMenu();
        Component component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        component.setFont(this.comboBox.getFont());
        if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor((Object)"ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor((Object)"ComboBox.disabledBackground"));
        }
        Dimension dimension = component.getPreferredSize();
        this.currentValuePane.paintComponent(graphics, component, (Container)this.comboBox, rectangle.x, rectangle.y, rectangle.width, dimension.height);
    }

    protected Rectangle rectangleForArrowIcon() {
        Rectangle rectangle = this.comboBox.getBounds();
        Border border = this.comboBox.getBorder();
        Insets insets = border.getBorderInsets((Component)this.comboBox);
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        rectangle.x = rectangle.x + rectangle.width - 3 - this.arrowIcon.getIconWidth();
        rectangle.y += (rectangle.height - this.arrowIcon.getIconHeight()) / 2;
        rectangle.width = this.arrowIcon.getIconWidth();
        rectangle.height = this.arrowIcon.getIconHeight();
        return rectangle;
    }

    protected Rectangle rectangleForCurrentValue() {
        Border border = this.comboBox.getBorder();
        Dimension dimension = this.comboBox.getSize();
        Insets insets = border.getBorderInsets((Component)this.comboBox);
        return new Rectangle(insets.left, insets.top, dimension.width - this.iconAreaWidth() - insets.left - insets.right, dimension.height - insets.bottom - insets.top);
    }

    public int iconAreaWidth() {
        if (this.comboBox.isEditable()) {
            return this.arrowIcon.getIconWidth() + 6;
        }
        return this.arrowIcon.getIconWidth() + 9 + 2;
    }

    protected boolean shouldActivatePopupForEvent(MouseEvent mouseEvent) {
        Rectangle rectangle = this.comboBox.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        return rectangle.contains(mouseEvent.getPoint());
    }

    public void validateMenu() {
        boolean bl = this.menu != null;
        super.validateMenu();
        if (!bl) {
            this.listBox.setBorder(null);
            this.menu.setBorder(MotifBorderFactory.getRaisedBevelBorder());
        }
    }

    protected int getPopupHeightForRowCount(int n) {
        return super.getPopupHeightForRowCount(n) + 2;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void layoutContainer(Container container) {
        if (this.editor != null) {
            Rectangle rectangle = this.rectangleForCurrentValue();
            ++rectangle.x;
            ++rectangle.y;
            --rectangle.width;
            rectangle.height -= 2;
            this.editor.setBounds(rectangle);
        }
    }

    protected void selectNextPossibleValue() {
        super.selectNextPossibleValue();
    }

    protected void selectPreviousPossibleValue() {
        super.selectPreviousPossibleValue();
    }

    protected void addKeyAccelerators(JComponent jComponent) {
        JComboBox jComboBox = this.comboBox;
        MotifComboBoxUI motifComboBoxUI = this;
        jComboBox.registerKeyboardAction((ActionListener)((Object)new 1(jComboBox, motifComboBoxUI)), KeyStroke.getKeyStroke((int)40, (int)0), 1);
        jComboBox.registerKeyboardAction((ActionListener)((Object)new 2(jComboBox, motifComboBoxUI)), KeyStroke.getKeyStroke((int)38, (int)0), 1);
        jComboBox.registerKeyboardAction((ActionListener)((Object)new 3(jComboBox, motifComboBoxUI)), KeyStroke.getKeyStroke((int)32, (int)0), 1);
    }

    protected void removeKeyAccelerators(JComponent jComponent) {
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke((int)40, (int)0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke((int)38, (int)0));
        this.comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke((int)32, (int)0));
    }

    static class MotifComboBoxArrowIcon
    implements Icon,
    Serializable {
        private Color lightShadow;
        private Color darkShadow;
        private Color fill;

        public MotifComboBoxArrowIcon(Color color, Color color2, Color color3) {
            this.lightShadow = color;
            this.darkShadow = color2;
            this.fill = color3;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            graphics.setColor(this.lightShadow);
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2 + 1, n + n3 - 3, n2 + 1);
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 1, n2 + 1);
            int n5 = n + 1;
            int n6 = n2 + 2;
            int n7 = n3 - 6;
            while (n6 + 1 < n2 + n4) {
                graphics.setColor(this.lightShadow);
                graphics.drawLine(n5, n6, n5 + 1, n6);
                graphics.drawLine(n5, n6 + 1, n5 + 1, n6 + 1);
                if (n7 > 0) {
                    graphics.setColor(this.fill);
                    graphics.drawLine(n5 + 2, n6, n5 + 1 + n7, n6);
                    graphics.drawLine(n5 + 2, n6 + 1, n5 + 1 + n7, n6 + 1);
                }
                graphics.setColor(this.darkShadow);
                graphics.drawLine(n5 + n7 + 2, n6, n5 + n7 + 3, n6);
                graphics.drawLine(n5 + n7 + 2, n6 + 1, n5 + n7 + 3, n6 + 1);
                ++n5;
                n7 -= 2;
                n6 += 2;
            }
            graphics.setColor(this.darkShadow);
            graphics.drawLine(n + n3 / 2, n2 + n4 - 1, n + n3 / 2, n2 + n4 - 1);
        }

        public int getIconWidth() {
            return 11;
        }

        public int getIconHeight() {
            return 11;
        }
    }

    private final class 1
    extends AbstractAction {
        private final /* synthetic */ JComboBox val$thisComboBox;
        private final /* synthetic */ MotifComboBoxUI val$thisUI;

        public void actionPerformed(ActionEvent actionEvent) {
            if (!MotifComboBoxUI.this.popupIsVisible()) {
                this.val$thisUI.showPopup();
                return;
            }
            this.val$thisUI.selectNextPossibleValue();
        }

        public boolean isEnabled() {
            return this.val$thisComboBox.isEnabled();
        }

        /* synthetic */ 1(JComboBox jComboBox, MotifComboBoxUI motifComboBoxUI2) {
            this.val$thisComboBox = jComboBox;
            this.val$thisUI = motifComboBoxUI2;
        }
    }

    private final class 2
    extends AbstractAction {
        private final /* synthetic */ JComboBox val$thisComboBox;
        private final /* synthetic */ MotifComboBoxUI val$thisUI;

        public void actionPerformed(ActionEvent actionEvent) {
            this.val$thisUI.selectPreviousPossibleValue();
        }

        public boolean isEnabled() {
            return this.val$thisComboBox.isEnabled() && MotifComboBoxUI.this.popupIsVisible();
        }

        /* synthetic */ 2(JComboBox jComboBox, MotifComboBoxUI motifComboBoxUI2) {
            this.val$thisComboBox = jComboBox;
            this.val$thisUI = motifComboBoxUI2;
        }
    }

    private static final class 3
    extends AbstractAction {
        private final /* synthetic */ JComboBox val$thisComboBox;
        private final /* synthetic */ MotifComboBoxUI val$thisUI;

        public void actionPerformed(ActionEvent actionEvent) {
            this.val$thisUI.showPopup();
        }

        public boolean isEnabled() {
            return this.val$thisComboBox.isEnabled();
        }

        /* synthetic */ 3(JComboBox jComboBox, MotifComboBoxUI motifComboBoxUI) {
            this.val$thisComboBox = jComboBox;
            this.val$thisUI = motifComboBoxUI;
        }
    }
}

